/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.menu;

import com.technicalitiesmc.lib.container.item.ItemContainer;
import com.technicalitiesmc.lib.menu.MenuComponent;
import com.technicalitiesmc.lib.menu.slot.TKGhostSlot;
import com.technicalitiesmc.lib.menu.slot.TKSlot;
import com.technicalitiesmc.lib.util.value.Reference;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Contract;

public abstract class TKMenu
extends AbstractContainerMenu {
    private final List<Region> regions = new ArrayList<Region>();
    private final Int2ObjectMap<Region> slotRegions = new Int2ObjectOpenHashMap();
    private final List<MenuComponent> components = new ArrayList<MenuComponent>();
    private final Tracker dataTracker = new Tracker();
    protected final Inventory playerInv;
    private final ResourceLocation texture;
    private final int width;
    private final int height;

    @Deprecated(forRemoval=true)
    protected TKMenu(RegistryObject<? extends MenuType<?>> type, int id, Inventory playerInv) {
        this(type, id, playerInv, null, 176, 166);
    }

    protected TKMenu(RegistryObject<? extends MenuType<?>> type, int id, Inventory playerInv, ResourceLocation texture, int width, int height) {
        super((MenuType)type.get(), id);
        this.playerInv = playerInv;
        this.texture = texture;
        this.width = width;
        this.height = height;
    }

    protected final Region createRegion() {
        Region region = new Region();
        this.regions.add(region);
        return region;
    }

    @Contract(value="_ -> param1", pure=true)
    protected final <T extends MenuComponent> T add(T component) {
        component.id = this.components.size();
        this.components.add(component);
        component.subscribe(this.dataTracker);
        return component;
    }

    public ResourceLocation texture() {
        return this.texture;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public ItemStack m_7648_(Player player, int slot) {
        Region region = (Region)this.slotRegions.get(slot);
        Slot s = (Slot)this.f_38839_.get(slot);
        if (region == null || !s.m_6657_() || !s.m_8010_(player)) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = s.m_7993_().m_41777_();
        for (RegionHandle handle : region.shiftTargets) {
            for (Slot target : handle.getSlots()) {
                if (!this.m_38903_(stack, target.f_40219_, target.f_40219_ + 1, false) || !stack.m_41619_()) continue;
                s.m_5852_(stack);
                return ItemStack.f_41583_;
            }
        }
        s.m_5852_(stack);
        return ItemStack.f_41583_;
    }

    public void onMessage(int component, byte[] data) {
        MenuComponent c = this.components.get(component);
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])data));
        c.onEvent(buf);
        buf.release();
    }

    public List<MenuComponent> components() {
        return this.components;
    }

    private class Tracker
    implements MenuComponent.DataTracker {
        private Tracker() {
        }

        @Override
        public void trackInts(final int[] array) {
            TKMenu.this.m_38884_(new ContainerData(){

                public int m_6413_(int i) {
                    return array[i];
                }

                public void m_8050_(int i, int value) {
                    array[i] = value;
                }

                public int m_6499_() {
                    return array.length;
                }
            });
        }

        @Override
        public void trackBoolean(final Reference<Boolean> reference) {
            TKMenu.this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return (Boolean)reference.get() != false ? 1 : 0;
                }

                public void m_6422_(int value) {
                    reference.set(value != 0);
                }
            });
        }

        @Override
        public void trackInt(final Reference<Integer> reference) {
            TKMenu.this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return (Integer)reference.get();
                }

                public void m_6422_(int value) {
                    reference.set(value);
                }
            });
        }

        @Override
        public void trackEnum(final Reference<? extends Enum<?>> reference) {
            TKMenu.this.m_38895_(new DataSlot(){

                public int m_6501_() {
                    return ((Enum)reference.get()).ordinal();
                }

                public void m_6422_(int value) {
                    Class<?> type = ((Enum)reference.get()).getClass();
                    reference.set(((Enum[])type.getEnumConstants())[value]);
                }
            });
        }
    }

    public final class Region
    implements RegionHandle {
        private final List<Slot> slots = new ArrayList<Slot>();
        private final List<RegionHandle> shiftTargets = new ArrayList<RegionHandle>();

        private Region() {
        }

        public Slot addSlot(int x, int y, Container container, int slot) {
            return this.addSlots(x, y, 1, 1, container, slot).iterator().next();
        }

        public Iterable<Slot> addSlots(int x, int y, int rows, int columns, Container container, int start) {
            return this.addSlots(x, y, rows, columns, (x1, y1, id) -> new Slot(container, id + start, x1, y1));
        }

        public TKSlot addSlot(int x, int y, ItemContainer inventory, int slot) {
            return this.addSlots(x, y, 1, 1, inventory, slot).iterator().next();
        }

        public Iterable<TKSlot> addSlots(int x, int y, int rows, int columns, ItemContainer inventory, int start) {
            return this.addSlots(x, y, rows, columns, (x1, y1, id) -> new TKSlot(x1, y1, inventory, id + start));
        }

        public TKGhostSlot addGhostSlot(int x, int y, ItemContainer inventory, int slot, int limit) {
            return this.addGhostSlots(x, y, 1, 1, inventory, slot, limit).iterator().next();
        }

        public Iterable<TKGhostSlot> addGhostSlots(int x, int y, int rows, int columns, ItemContainer inventory, int start, int limit) {
            return this.addSlots(x, y, rows, columns, (x1, y1, id) -> new TKGhostSlot(x1, y1, inventory, id + start, limit));
        }

        public <T extends Slot> Iterable<T> addSlots(int x, int y, int rows, int columns, SlotFactory<T> slotFactory) {
            int firstIndex = this.slots.size();
            for (int j = 0; j < rows; ++j) {
                for (int i = 0; i < columns; ++i) {
                    this.addSlot(slotFactory.createSlot(x + i * 18, y + j * 18, i + j * columns));
                }
            }
            return this.slots.subList(firstIndex, this.slots.size());
        }

        public <T extends Slot> T addSlot(T slot) {
            this.slots.add(slot);
            TKMenu.this.slotRegions.put(TKMenu.this.f_38839_.size(), (Object)this);
            TKMenu.this.m_38897_(slot);
            return slot;
        }

        public void addPlayerSlots(Inventory playerInv) {
            this.addPlayerSlots(playerInv, false);
        }

        public void addPlayerSlots(Inventory playerInv, boolean lockSelected) {
            this.addPlayerSlots((TKMenu.this.width - 160) / 2, TKMenu.this.height - 82, playerInv, lockSelected);
        }

        public void addPlayerSlots(int x, int y, Inventory playerInv) {
            this.addPlayerSlots(x, y, playerInv, false);
        }

        public void addPlayerSlots(int x, int y, Inventory playerInv, boolean lockSelected) {
            if (lockSelected) {
                this.addSlots(x, y, 3, 9, (Container)playerInv, 9);
                this.addSlots(x, y + 58, 1, 9, (x1, y1, id) -> new Slot((Container)playerInv, id, x1, y1){

                    public boolean m_8010_(Player player) {
                        return this.getSlotIndex() != ((Inventory)this.f_40218_).f_35977_;
                    }

                    public boolean m_5857_(ItemStack stack) {
                        return this.getSlotIndex() != ((Inventory)this.f_40218_).f_35977_;
                    }
                });
            } else {
                this.addSlots(x, y, 3, 9, (Container)playerInv, 9);
                this.addSlots(x, y + 58, 1, 9, (Container)playerInv, 0);
            }
        }

        public void onChanged(Consumer<TKSlot> callback) {
            for (Slot slot : this.slots) {
                if (!(slot instanceof TKSlot)) continue;
                TKSlot s = (TKSlot)slot;
                s.onChanged(callback);
            }
        }

        public void addShiftTargets(RegionHandle ... regions) {
            this.shiftTargets.addAll(Arrays.asList(regions));
        }

        @Override
        public List<Slot> getSlots() {
            return this.slots;
        }

        public Reversed reversed() {
            return new Reversed();
        }

        public final class Reversed
        implements RegionHandle {
            private Reversed() {
            }

            @Override
            public List<Slot> getSlots() {
                ArrayList<Slot> list = new ArrayList<Slot>(Region.this.slots);
                Collections.reverse(list);
                return list;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface RegionHandle {
        public List<Slot> getSlots();
    }

    @FunctionalInterface
    public static interface SlotFactory<T extends Slot> {
        public T createSlot(int var1, int var2, int var3);
    }
}

